<?php

namespace App\Http\Controllers\Admin;

use Auth; 
use App\Reports;
 
use Illuminate\Http\Request;
use Session; 

class ReportsController extends MainAdminController
{
 
    public function list()
    {  
        if(Auth::User()->usertype!="Admin" AND Auth::User()->usertype!="Sub_Admin")
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('dashboard');            
        }

        if(isset($_GET['s']))
        {
            $keyword = $_GET['s'];  
            $list = Reports::where("message", "LIKE","%$keyword%")->orderBy('message')->paginate(10);

            $list->appends(\Request::only('s'))->links();
        }         
        else
        { 
            $list = Reports::orderBy('id','DESC')->paginate(10);
        }
        
        $page_title=trans('words.reports');

        return view('admin.pages.reports.list',compact('page_title','list'));
    }

     
    public function delete($post_id)
    {
        if(Auth::User()->usertype=="Admin" OR Auth::User()->usertype=="Sub_Admin")
        {            
             $data_obj = Reports::findOrFail($post_id);
             $data_obj->delete();

             Session::flash('flash_message', trans('words.deleted'));
             return redirect()->back();             
            
        }
        else
        {
            Session::flash('flash_message', trans('words.access_denied'));
            return redirect('admin/dashboard');            
        
        }
    }
 
}
